/*
 * Decompiled with CFR 0.152.
 */
package app;

import app.FitAmbiguity;
import app.FitData;
import app.FitFourier;
import app.FitSlope;
import app.RawDataSet;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import util.Config;
import util.Logger;
import view.MainView;

public class FitDataSet {
    static Logger logger = Logger.getLogger();
    private Map<Double, FitData> DataMap;
    private MainView myView;
    private RawDataSet rawData;
    private String CorrAlgo;
    private double minSlope;
    private double maxSlope;

    public String getCorrAlgo() {
        return this.CorrAlgo;
    }

    public void setCorrAlgo(String algo) {
        Config cfg = Config.getConfig();
        if (algo.equals("Slope")) {
            this.CorrAlgo = "Slope";
            cfg.setParam("CorrAlgo", "Slope");
        } else if (algo.equals("Ambi")) {
            this.CorrAlgo = "Ambi";
            cfg.setParam("CorrAlgo", "Ambi");
        } else {
            this.CorrAlgo = "Fourier";
            cfg.setParam("CorrAlgo", "Fourier");
        }
        for (double f : this.DataMap.keySet()) {
            this.DataMap.put(f, null);
        }
    }

    public double getMinSlope() {
        return this.minSlope;
    }

    public double getMaxSlope() {
        return this.maxSlope;
    }

    public void setSlopeLimits(double min, double max) {
        this.minSlope = min;
        this.maxSlope = max;
        Config cfg = Config.getConfig();
        cfg.setParam("minSlope", String.valueOf(min));
        cfg.setParam("maxSlope", String.valueOf(max));
    }

    public FitDataSet(MainView pView, RawDataSet rd) {
        logger.entry(4, "FitDataSet.FitDataSet");
        this.myView = pView;
        this.rawData = rd;
        this.DataMap = new TreeMap<Double, FitData>();
        Config cfg = Config.getConfig();
        this.CorrAlgo = cfg.getParam("CorrAlgo");
        this.minSlope = cfg.getParamToDouble("minSlope");
        this.maxSlope = cfg.getParamToDouble("maxSlope");
        for (double f : this.rawData.getFreqList()) {
            this.DataMap.put(f, null);
        }
        logger.exit(4, "FitDataSet.FitDataSet");
    }

    public Set<Double> getFrequencies() {
        return this.DataMap.keySet();
    }

    private boolean check(double freq) {
        if (this.DataMap.get(freq) == null) {
            ArrayList<Double> tgs = new ArrayList<Double>();
            ArrayList<Double> azis = new ArrayList<Double>();
            this.rawData.getFitInput(tgs, azis, freq);
            FitData fd = this.CorrAlgo.equals("Slope") ? new FitSlope(this.myView, tgs.size(), this.minSlope, this.maxSlope) : (this.CorrAlgo.equals("Ambi") ? new FitAmbiguity(this.myView, tgs.size()) : new FitFourier(this.myView, tgs.size()));
            int i = 0;
            while (i < tgs.size()) {
                fd.addInput(i, (Double)tgs.get(i), (Double)azis.get(i));
                ++i;
            }
            this.DataMap.put(freq, fd);
            return false;
        }
        return true;
    }

    public FitData getFitData(double freq) {
        logger.entry(6, "FitDataSet.getFitData");
        if (!this.check(freq)) {
            this.DataMap.get(freq).fitCorr();
        }
        logger.exit(6, "FitDataSet.getFitData");
        return this.DataMap.get(freq);
    }

    public void fitCorrection(double freq) {
        this.check(freq);
        this.DataMap.get(freq).fitCorr();
    }

    public double getGlobalRMS() {
        logger.entry(4, "FitDataSet.getGlobalRMS");
        int count = 0;
        double rms = 0.0;
        double delta = 0.0;
        for (double freq : this.DataMap.keySet()) {
            ++count;
            if (!this.check(freq)) {
                this.DataMap.get(freq).fitCorr();
            }
            delta = this.DataMap.get(freq).getRmsSimul();
            rms += delta * delta;
        }
        rms = Math.sqrt(rms / (double)count);
        logger.exit(4, "FitDataSet.getGlobalRMS");
        return rms;
    }

    public double getRmsForTarget(double tg) {
        logger.entry(4, "FitDataSet.getRmsForTarget " + tg);
        int count = 0;
        double rms = 0.0;
        double delta = 0.0;
        for (double freq : this.DataMap.keySet()) {
            ++count;
            if (!this.check(freq)) {
                this.DataMap.get(freq).fitCorr();
            }
            double val = this.rawData.getActualBearing(tg, freq);
            double crv = this.DataMap.get(freq).getCorrectedVal(val);
            delta = crv - tg;
            logger.log(5, "freq, delta = " + freq + ", " + delta);
            rms += delta * delta;
        }
        rms = Math.sqrt(rms / (double)count);
        logger.exit(4, "FitDataSet.getRmsForTarget, rms = " + rms);
        return rms;
    }
}

